﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using System.Windows.Media.Imaging;
using Microsoft.Maps.MapControl;

namespace Media
{
    public partial class MainPage : UserControl
    {
        public MainPage()
        {
            InitializeComponent();

            //AddImageToMap();
            //AddVideoToMap();

            // Changes the initial zoom level of the map.
            MapWithPushpins.ZoomLevel = 3;
        }

        private void MapWithPushpins_MouseDoubleClick(object sender, MapMouseEventArgs e)
        {
            // Disables the default mouse double-click action.
            e.Handled = true;

            // The location to place the pushpin at on the map.
            Location pinLocation = MapWithPushpins.ViewportPointToLocation(e.ViewportPoint);

            // The pushpin to add to the map.
            Pushpin pin = new Pushpin();
            pin.Location = pinLocation;

            // Adds the pushpin to the map.
            MapWithPushpins.Children.Add(pin);
        }

        //*************************************
        public void AddImageToMap()
        {
            MapLayer imageLayer = new MapLayer();

            Image image = new Image();
            //Define the URI location of the image
            image.Source = new System.Windows.Media.Imaging.BitmapImage(new Uri("Images/Penguins.jpg", UriKind.Relative));
            //Define the image display properties
            image.Opacity = 0.8;
            image.Stretch = System.Windows.Media.Stretch.Uniform;
            image.Height = 70;
            image.Width = 70;
            //The map location to place the image at
            Location location = new Location() { Latitude = 50.94138, Longitude = 6.95824 };
            //Center the image around the location specified
            PositionOrigin position = PositionOrigin.Center;

            //Add the image to the defined map layer
            imageLayer.AddChild(image, location, position);
            //Add the image layer to the map
            MapWithPushpins.Children.Add(imageLayer);
        }

        public void AddVideoToMap()
        {
            MapLayer imageLayer = new MapLayer();

            MediaElement video = new MediaElement();
            //Define the URI location of the video
            video.Source = new Uri(@"http://mschnlnine.vo.llnwd.net/d1/ch9/9/2/9/9/1/4/TCS2NBCOlympics_ch9.wmv",
                    UriKind.RelativeOrAbsolute);
            //Define the video display properties
            video.Opacity = 0.8;
            video.Width = 250;
            video.Height = 200;

            //The map location to place the video at
            Location location = new Location() { Latitude = 50.94138, Longitude = 6.95824 };
            //Center the video around the location specified
            PositionOrigin position = PositionOrigin.Center;

            //Add the video to the defined map layer
            imageLayer.AddChild(video, location, position);
            //Add the video layer to the map
            MapWithPushpins.Children.Add(imageLayer);
        }


    }
}
